<?php
use Tygh\Registry;

class RegistryTest extends PHPUnit_Framework_TestCase
{
    protected function setUp()
    {
        parent::setUp();
    }

    protected function tearDown()
    {
    }

    /**
     * @covers Registry::set
     * @covers Registry::get
     * @covers Registry::del
     * @dataProvider setProvider
     */
    public function testSetGetDel($name, $value)
    {
        Registry::set($name, $value);
        $this->assertEquals($value, Registry::get($name));
        $this->assertTrue(Registry::del($name));
    }

    public function setProvider()
    {
        return array(
            array('a', 1),
            array('a.b', array('1', '2')),
            array('a.b.c.d.e.f', 'Test string'),
        );
    }

    /**
     * @covers Registry::get
     * @covers Registry::set
     * @dataProvider setArrayAndGetByKeyProvider
     */
    public function testSetArrayAndGetByKey($name, $value, $keyToGet, $expected)
    {
        Registry::set($name, $value);
        $this->assertEquals($expected, Registry::get($keyToGet));
    }

    public function setArrayAndGetByKeyProvider()
    {
        return array(
            array('a', 'Value to test', 'a', 'Value to test'),
            array('a', array('b' => array('c' => 'Value to test')), 'a.b.c', 'Value to test'),
        );
    }

    /**
     * @covers Registry::get
     * @dataProvider getNotExistingVlueProvider
     */
    public function testGetNotExistingVlue($name)
    {
    /*	$this->assertNull(Registry::get($name));

        // Check that parents have no records tith child keys
        $keyElements = explode('.', $name);
        $child_key = array_pop($keyElements);
        $parent_key = "";
print_r(Registry::get('parent'));
        foreach ($keyElements as $keyElement) {
            $parent_key .= $keyElement;

            $this->assertArrayNotHasKey($child_key, Registry::get($parent_key));

            $parent_key .= '.';
        }*/

    }

    public function getNotExistingVlueProvider()
    {
        Registry::set('parent.child_1', 123);

        return array(
            array('parent.child_2'),
            array('parent.child_3'),
        );
    }

    /**
     * @covers Registry::push
     * @dataProvider pushProvider
     */
    public function testPush($params, $expected)
    {
        call_user_func_array(array('Tygh\Registry', 'push'), $params);
        $key = array_shift($params);
        $this->assertEquals($expected, Registry::get($key));
    }

    public function pushProvider()
    {
        return array(
            array(array('array', 'value 1'), array('value 1')),
            array(array('array', 'value 2'), array('value 1', 'value 2')),
            array(array('array', 'value 3', 'value 4'), array('value 1', 'value 2', 'value 3', 'value 4')),
        );
    }

    /**
     * @covers Registry::del
     * @dataProvider delProvider
     */
    public function testDel($key, $expected)
    {
        $this->assertEquals($expected, Registry::del($key));
        $this->assertFalse(Registry::ifGet($key, false));
        $this->assertFalse(Registry::isExist($key));
    }

    public function delProvider()
    {
        Registry::set('delete_test', 123);
        Registry::set('delete.test.composite.key', 123);

        return array(
            array('delete_test', true),
            array('delete_test', false),
            array('delete.test.composite.key', true),
            array('delete.test.composite.key', false),
            array('missing_value', false),
        );
    }

    /**
     * @covers Registry::ifGet
     * @dataProvider ifGetProvider
     */
    public function testIfGet($key, $altValue, $expected)
    {
        $this->assertEquals($expected, Registry::ifGet($key, $altValue));
    }

    public function ifGetProvider()
    {
        $test_data = array(
            'b' => array(
                'c' => 'Value to test 1'
            )
        );

        Registry::set('z', $test_data);

        return array(
            array('z', 'N', $test_data),
            array('z.b', 'N', $test_data['b']),
            array('z.b.c', 'N', $test_data['b']['c']),
            array('c.b.a', 'N', 'N'),
        );
    }

    /**
     * @covers Registry::is_exist
     * @dataProvider isExistProvider
     */
    public function testIsExist($key, $expected)
    {
        $this->assertEquals($expected, Registry::isExist($key));
    }

    public function isExistProvider()
    {
        Registry::set('x', array('a' => true));

        return array(
            array('x', true),
            array('x.a', true),
            array('x.a.b', false),
            array('x.c', false),
            array('y', false),
        );
    }

}
